//
//  NSFileManager+MCAdditions.h
//  MCFoundation
//
//  Created by Michael Clark on Wed Jan 22 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface NSFileManager (MCAdditions)
- (BOOL)recursivelyCreateDirectoryAtPath: (NSString *)path attributes: (NSDictionary *)attributes;

- (void)createPathToFile:(NSString *)path attributes:(NSDictionary *)attributes;
    // Creates any directories needed to be able to create a file at the specified path.  Raises an exception on failure.

- (BOOL)directoryExistsAtPath:(NSString *)path traverseLink:(BOOL)traverseLink;
- (BOOL)directoryExistsAtPath:(NSString *)path;


- (NSNumber *)posixPermissionsForMode:(unsigned int)mode;
- (NSNumber *)defaultFilePermissions;
- (NSNumber *)defaultDirectoryPermissions;


// The command line program ditto to copy the given path to the toPath.
// This method ensures that ditto with maintain resource forks
- (BOOL)dittoPath: (NSString *)path toPath: (NSString *)toPath handler: (id)handler;

//Uses /usr/bin/which to try to determine which path to use for a particular command. Returns nil on failure.
- (NSString *)whichPathForCommand:(NSString *)aCommand;

// Uses the /usr/bin/tar command to tar up the given path to the give file
- (BOOL)tarPath: (NSString *)path toFile: (NSString *)toFile;
- (BOOL)extractTarPath: (NSString *)path;
- (BOOL)extractTarPath: (NSString *)path toPath:(NSString *)destPath;

- (BOOL)gzipPath: (NSString *)path;
- (BOOL)gunzipPath: (NSString *)path;

- (BOOL)unzipPath: (NSString *)path toPath: (NSString*)destPath;
- (BOOL)zipPath:(NSString *)path toPath:(NSString*)destPath;

// Uses the /usr/bin/tail command to tail the given file to number of lines into the toFile
// Note: This will not destructively overright the toFile, it fails if it already exists
- (BOOL)tailFileAtPath: (NSString*)path toFile: (NSString*)toFile lines: (unsigned int)lines;

- (BOOL)rotatePathAtPath:(NSString *)path threshold: (int)threshold createFolderAfterRotate:(BOOL)createFolder;
- (BOOL)rotatePathAtPath:(NSString *)path threshold: (int)threshold;
- (BOOL)rotateFileAtPath:(NSString *)path threshold: (int)threshold;
// Call the main method with NO for thresholdIndexAtEnd
- (BOOL)rotateFileAtPath:(NSString *)path threshold: (int)threshold thresholdIndexAtEnd: (BOOL)flag;
	// if you want your log file to have the rotation threshold at the very end pass yes for flag i.e. mylog.txt.1
	// if you want your log file to have the rotation threshold at the end of the filename before the extension pass NO for flag, i.e. mylog1.txt
- (BOOL)rotateFileAtPath:(NSString *)path minimumSize:(long long)bytes threshold:(int)threshold thresholdIndexAtEnd: (BOOL)flag;


- (NSArray*)filenamesExcludingExtensionInPath:(NSString*)aPath;
- (NSArray*)sortedFilenamesExcludingExtensionInPath:(NSString*)aPath;

- (NSArray*)sortedFilenamesExcludingExtensionAndHiddenFilesInPath:(NSString*)aPath;

// A dictionary containing the full path (key="Path") and modify date (key=NSFileModificationDate) for the most recently modified file in the folder passed
- (NSDictionary *)lastModifiedFileAndDateForDirectoryAtPath:(NSString *)path withExtension:(NSString *)anExtension;

// Recursively checks if the file specified is writable and all folders in the heirarchy are also writable for the given user/group
- (BOOL)isFileWritableByUsername:(NSString *)user groupname:(NSString *)group path:(NSString *)path;

// Recursively checks if the file specified is readable and all folders in the heirarchy are also readable for the given user/group
- (BOOL)isFileReadableByUsername:(NSString *)user groupname:(NSString *)group path:(NSString *)path;
@end
